' VB Script to show how to use the ADSearch function from a Windows Script      '
' component.                                                                    '
'                                                                               '
' Version 1.00 - Alain Lissoir                                                  '
' Compaq Computer Corporation - Professional Services - Belgium -               '
'                                                                               '
' Any comments or questions:                     EMail:alain.lissoir@compaq.com '

Option Explicit

Dim objADSearch
Dim objResultList
Dim objResult
Dim intColumnPosition

Set objADSearch = CreateObject("ADSearch.WSC")

objADSearch.NamingContext = "DefaultNamingContext"
objADSearch.Filter = "(|(objectClass=domainDNS)(objectClass=organizationalUnit))"
objADSearch.Attributes = "name,distinguishedName"
objADSearch.Depth = "subTree"

Set objResultList = objADSearch.Execute

WScript.Echo
WScript.Echo "Number of record found is " & objResultList.Item ("RecordCount")
WScript.Echo "Number of elements in the Scripting Dictionary object is " & objResultList.Count

For Each objResult in objResultList
    intColumnPosition = InStr (objResult, ":")
    If intColumnPosition Then
       Wscript.Echo Mid (objResult, 1, intColumnPosition - 1) & _
                        "=>" & objResultList.Item (objResult)
    End If
Next